/*
 * Decompiled with CFR 0.152.
 */
package software.bernie.geckolib;

import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import software.bernie.geckolib.GeckoLibConstants;
import software.bernie.geckolib.service.GeckoLibNetworking;
import software.bernie.geckolib.service.GeckoLibPlatform;

public final class GeckoLibServices {
    public static final GeckoLibPlatform PLATFORM = GeckoLibServices.load(GeckoLibPlatform.class);
    public static final GeckoLibNetworking NETWORK = GeckoLibServices.load(GeckoLibNetworking.class);

    private static <T> T load(Class<T> clazz) {
        return GeckoLibServices.load(clazz, null);
    }

    private static <T> T load(Class<T> clazz, @Nullable Supplier<T> defaultInstance) {
        T loadedService = ServiceLoader.load(clazz).findFirst().or(defaultInstance == null ? Optional::empty : () -> Optional.of(defaultInstance.get())).orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
        GeckoLibConstants.LOGGER.debug("Loaded {} for service {}", loadedService, clazz);
        return loadedService;
    }
}

